package ch.frankel.blog.hibernate.model;

import static javax.persistence.GenerationType.IDENTITY;
import static org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import org.hibernate.annotations.Cache;

/**
 * A person.
 * 
 * @author Nicolas Frnkel
 * @since 14 juin 2009
 */
@Entity
@Cache(usage = READ_WRITE)
public class Person {

    @Id
    @GeneratedValue(strategy = IDENTITY)
    private long id;

    @Column(name = "FIRST_NAME")
    private String firstName;

    @Column(name = "LAST_NAME")
    private String lastName;

    private Date birthDate;

    public Date getBirthDate() {

        return birthDate;
    }

    public String getFirstName() {

        return firstName;
    }

    public long getId() {

        return id;
    }

    public String getLastName() {

        return lastName;
    }

    public void setBirthDate(Date aBirthDate) {

        birthDate = aBirthDate;
    }

    public void setFirstName(String aFirstName) {

        firstName = aFirstName;
    }

    public void setId(long aId) {

        id = aId;
    }

    public void setLastName(String aLastName) {

        lastName = aLastName;
    }
}
