package ch.frankel.blog.hades.dao;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import ch.frankel.blog.hades.entity.Teacher;

@ContextConfiguration(locations = { "classpath:config/beans.xml", "classpath:datasource.xml" })
public class TeacherDaoTest extends AbstractTestNGSpringContextTests {

	@Autowired
	private TeacherDao teacherDao;

	@Autowired
	private DataSource dataSource;

	@BeforeClass
	protected void setUpBeforeClass() throws Exception {

		Connection conn = dataSource.getConnection();

		try {

			Statement delete = conn.createStatement();
			
			delete.execute("DELETE FROM TEACHER");
			
			PreparedStatement insert = conn
					.prepareStatement("INSERT INTO TEACHER (ID, NAME) VALUES (?,?)");

			insert.setInt(1, 1);
			insert.setString(2, "Joe");

			insert.executeUpdate();

			insert.setInt(1, 2);
			insert.setString(2, "Jack");

			insert.executeUpdate();

			insert.setInt(1, 3);
			insert.setString(2, "William");

			insert.executeUpdate();

			insert.setInt(1, 4);
			insert.setString(2, "Averell");

			insert.executeUpdate();

		} finally {

			conn.close();
		}
	}

	@Test
	public void testReadAll() {

		List<Teacher> teachers = teacherDao.readAll();
		
		assertNotNull(teachers);
		assertEquals(teachers.size(), 4);
	}

	@Test
	public void testFindByNameLike() {

		List<Teacher> teachers = teacherDao.findByNameLike("J%");
		
		assertNotNull(teachers);
		assertEquals(teachers.size(), 2);
	}

	@Test
	public void testFindByNameSizeMax() {

		List<Teacher> teachers = teacherDao.findByNameSizeMax(6);
		
		assertNotNull(teachers);
		assertEquals(teachers.size(), 2);
	}

	@Test
	public void testGetIdNameSizeJoe1() {

		long size = teacherDao.getIdNameSize(1);
		
		assertEquals(size, 4);
	}

	@Test
	public void testGetIdNameSizeJack2() {

		long size = teacherDao.getIdNameSize(2);
		
		assertEquals(size, 6);
	}
}
