package ch.frankel.blog.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.jar.Manifest;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VersionServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		Writer writer = response.getWriter();

		response.setContentType("text/html");

		writer.write("<html><body>Version is: ");

		ServletContext application = getServletConfig().getServletContext();

		InputStream inputStream = application.getResourceAsStream("/META-INF/MANIFEST.MF");
		
		Manifest manifest = new Manifest(inputStream);
		
		String version = manifest.getMainAttributes().getValue("Implementation-Version");

		writer.write(version == null ? "unknown" : version);

		writer.flush();
	}
}
