import static org.jvnet.flamingo.ribbon.RibbonElementPriority.MEDIUM;
import static org.jvnet.flamingo.ribbon.RibbonElementPriority.TOP;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;

import javax.swing.SwingUtilities;

import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.icon.ImageWrapperResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonFrame;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenu;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.resize.CoreRibbonResizePolicies;
import org.jvnet.flamingo.ribbon.resize.IconRibbonBandResizePolicy;

/**
 * Main Frame to demonstrate ribbon use.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @date 26 juin 2010
 * @version 1.0
 * 
 */
public class MainFrame extends JRibbonFrame {

    /** Serial version unique id. */
    private static final long serialVersionUID = 1L;

    public static ResizableIcon getResizableIconFromResource(String resource) {

	return ImageWrapperResizableIcon.getIcon(MainFrame.class
		.getClassLoader().getResource(resource), new Dimension(48, 48));
    }

    /**
     * Entry point method.
     * 
     * @param args
     *            Application arguments
     */
    public static void main(String[] args) {

	SwingUtilities.invokeLater(new Runnable() {

	    @Override
	    public void run() {

		MainFrame frame = new MainFrame();

		frame.setDefaultCloseOperation(EXIT_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);

		JRibbonBand band1 = new JRibbonBand(
			"Hello",
			getResizableIconFromResource("48px-Crystal_Clear_app_Staroffice.png"));
		JRibbonBand band2 = new JRibbonBand("world!", null);

		JCommandButton button1 = new JCommandButton(
			"Square",
			getResizableIconFromResource("48px-Crystal_Clear_app_kthememgr.png"));
		JCommandButton button2 = new JCommandButton(
			"Circle",
			getResizableIconFromResource("48px-Crystal_Clear_app_ksame.png"));
		JCommandButton button3 = new JCommandButton(
			"Triangle",
			getResizableIconFromResource("48px-Crystal_Clear_app_error.png"));
		JCommandButton button4 = new JCommandButton(
			"Star",
			getResizableIconFromResource("48px-Crystal_Clear_action_bookmark.png"));

		band1.addCommandButton(button1, TOP);
		band1.addCommandButton(button2, MEDIUM);
		band1.addCommandButton(button3, MEDIUM);
		band1.addCommandButton(button4, MEDIUM);

		band1.setResizePolicies((List) Arrays.asList(
			new CoreRibbonResizePolicies.None(band1.getControlPanel()),
			new CoreRibbonResizePolicies.Mirror(band1.getControlPanel()),
			new CoreRibbonResizePolicies.Mid2Low(band1.getControlPanel()),
			new CoreRibbonResizePolicies.High2Low(band1.getControlPanel()),
			new IconRibbonBandResizePolicy(band1.getControlPanel())));
		band2.setResizePolicies((List) Arrays
			.asList(new IconRibbonBandResizePolicy(band2
				.getControlPanel())));

		RibbonTask task1 = new RibbonTask("One", band1);
		RibbonTask task2 = new RibbonTask("Two", band2);

		frame.getRibbon().addTask(task1);
		frame.getRibbon().addTask(task2);
		
		frame.getRibbon().setApplicationMenu(new RibbonApplicationMenu());
	    }
	});
    }
}
