package ch.frankel.blog.spring.data.entity;

import static javax.persistence.InheritanceType.JOINED;
import static javax.persistence.TemporalType.DATE;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.Temporal;

import org.springframework.data.jpa.domain.AbstractPersistable;

@Entity
@Inheritance(strategy = JOINED)
public class Person extends AbstractPersistable<Long> {

	private static final long serialVersionUID = 1L;

	private String firstName;

	private String lastName;

	@Temporal(DATE)
	private Date birthdate;

	public Date getBirthdate() {

		return birthdate;
	}

	public String getFirstName() {

		return firstName;
	}

	public String getLastName() {

		return lastName;
	}

	public void setBirthdate(Date birthdate) {

		this.birthdate = birthdate;
	}

	public void setFirstName(String firstName) {

		this.firstName = firstName;
	}

	public void setLastName(String lastName) {

		this.lastName = lastName;
	}
}
