package ch.frankel.blog.spring.data.entity;

import java.util.List;

import javax.persistence.Entity;
import javax.persistence.OneToMany;

import org.springframework.data.jpa.domain.AbstractPersistable;

@Entity
public class Company extends AbstractPersistable<Long> {

	private static final long serialVersionUID = 1L;

	private String name;
	
	@OneToMany(mappedBy = "company")
	private List<Employee> employees;

	String getName() {
	
		return name;
	}

	List<Employee> getEmployees() {
	
		return employees;
	}

	void setName(String name) {
	
		this.name = name;
	}

	void setEmployees(List<Employee> employees) {
	
		this.employees = employees;
	}
}
