package ch.frankel.blog.spring.data.repository;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertFalse;
import static org.testng.Assert.assertNotNull;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import ch.frankel.blog.spring.data.entity.Person;

@TransactionConfiguration(defaultRollback = false)
@ContextConfiguration("classpath:spring-persistence.xml")
public class PersonRepositoryTest extends AbstractRepositoryTest {

	@Resource
	private PersonRepository repository;

	@BeforeMethod
	protected void setUp() {

		super.setUp();
	}

	@Test
	public void countAllPersonShouldBe5() {

		assertEquals(repository.count(), 5);
	}

	@Test
	public void countPersonNamedDoeShouldBe2() {

		List<Person> persons = repository.findByLastName("Doe");

		assertNotNull(persons);
		assertFalse(persons.isEmpty());
		assertEquals(persons.size(), 2);
	}

	@Test
	public void countPersonWhoseNameContainDShouldBe3() {

		List<Person> persons = repository.findByLastNameContaining("D");

		assertNotNull(persons);
		assertFalse(persons.isEmpty());
		assertEquals(persons.size(), 3);
	}

	@Test
	public void countPersonsWhoseNameContainDIgnoringCaseShouldBe4() {

		List<Person> persons = repository.findByLastNameIgnoreCaseContaining("D");

		assertNotNull(persons);
		assertFalse(persons.isEmpty());
		assertEquals(persons.size(), 4);
	}

	@Test
	public void countPersonsWhoAreNotEmployeesShouldBe3() {

		List<Person> persons = repository.findPersonWhoAreNotEmployees();

		assertNotNull(persons);
		assertFalse(persons.isEmpty());
		assertEquals(persons.size(), 3);
	}
}
