package ch.frankel.blog.spring.data.repository;

import static org.testng.Assert.assertEquals;

import java.util.Date;

import javax.annotation.Resource;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import ch.frankel.blog.spring.data.entity.Employee;

@TransactionConfiguration(defaultRollback = false)
@ContextConfiguration("classpath:spring-persistence.xml")
public class EmployeeRepositoryTest extends AbstractRepositoryTest {

	@Resource
	private EmployeeRepository repository;

	@BeforeMethod
	protected void setUp() {

		super.setUp();
	}

	@Test
	public void countAllEmployeeShouldBe2() {

		assertEquals(repository.count(), 2);
	}

	@Test
	public void countAllEmployeeAfterInserting1ShouldBe3() {

		Employee employee = new Employee();

		employee.setFirstName("John");
		employee.setLastName("Travolta");
		employee.setBirthdate(new Date());

		repository.save(employee);

		assertEquals(repository.count(), 3);
	}

	@Test
	public void highestPaidEmployeeShouldBeJaneDoe() {

		final Employee highestPaidEmployee = repository.findHighestPaidEmployee();

		assertEquals(highestPaidEmployee.getId().longValue(), 2);
	}
}
