package ch.frankel.blog.spring.data.repository;

import java.util.Date;

import org.joda.time.DateMidnight;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;

public abstract class AbstractRepositoryTest extends AbstractTransactionalTestNGSpringContextTests {

	@SuppressWarnings("deprecation")
	protected void setUp() {

		simpleJdbcTemplate.update("DELETE FROM EMPLOYEE");
		simpleJdbcTemplate.update("DELETE FROM PERSON");
		simpleJdbcTemplate.update("DELETE FROM COMPANY");
		simpleJdbcTemplate.update("INSERT INTO COMPANY (ID, NAME) VALUES(1, 'The World Company')");
		simpleJdbcTemplate.update("INSERT INTO PERSON (ID, FIRSTNAME, LASTNAME, BIRTHDATE) VALUES"
			+ "(1, 'John', 'Doe', ?),(2, 'Jane', 'Doe', ?),(3, 'Henry', 'Fonda', ?), (4, 'Val', 'Kilmer', ?),(5, 'Timothy', 'Dalton', ?)",
				new DateMidnight(new Date().getTime()).toDate(), new DateMidnight(new Date().getTime()).toDate(),
				new DateMidnight(1905, 5, 16).toDate(), new DateMidnight(1959, 12, 31).toDate(), new DateMidnight(1946, 3, 21).toDate());
		simpleJdbcTemplate.update("INSERT INTO EMPLOYEE (ID, POSITION, SALARY, COMPANY_ID) VALUES(1, 'Janitor', 2000, 1), (2, 'Illuminati', 200000, 1)");
	}
}
