package ch.frankel.blog.spring.data.entity;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;

@Entity
@NamedQuery( name = "Employee.findHighestPaidEmployee", query = "SELECT e FROM Employee e WHERE e.salary = (SELECT MAX(emp.salary) FROM Employee emp)")
public class Employee extends Person {

	private static final long serialVersionUID = 1L;

	private String position;

	private Double salary;

	@ManyToOne
	private Company company;

	String getPosition() {
	
		return position;
	}

	Double getSalary() {
	
		return salary;
	}

	public Company getCompany() {
	
		return company;
	}

	void setPosition(String position) {
	
		this.position = position;
	}

	void setSalary(Double salary) {
	
		this.salary = salary;
	}

	public void setCompany(Company company) {
	
		this.company = company;
	}
}
