package ch.frankel.blog.spring.data.repository.custom.jpa;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import ch.frankel.blog.spring.data.entity.Employee;
import ch.frankel.blog.spring.data.entity.Person;
import ch.frankel.blog.spring.data.repository.custom.CustomPersonRepository;

public class CustomPersonRepositoryImpl implements CustomPersonRepository {

	@PersistenceContext
	private EntityManager entityManager;

	@Override
	public List<Person> findPersonWhoAreNotEmployees() {

		CriteriaBuilder builder = entityManager.getCriteriaBuilder();

		CriteriaQuery<Person> criteria = builder.createQuery(Person.class);

		Root<Person> fromPerson = criteria.from(Person.class);

		Predicate personIsNotEmployee = builder.not(fromPerson.type().in(Employee.class));

		criteria.select(fromPerson).where(personIsNotEmployee);

		TypedQuery<Person> query = entityManager.createQuery(criteria);

		return query.getResultList();
	}
}
