package ch.frankel.blog.spring.data.repository;

import java.util.List;

import org.springframework.data.repository.RepositoryDefinition;

import ch.frankel.blog.spring.data.entity.Person;
import ch.frankel.blog.spring.data.repository.custom.CustomPersonRepository;

@RepositoryDefinition(domainClass = Person.class, idClass = Long.class)
public interface PersonRepository extends CustomPersonRepository {

	long count();
	
	List<Person> findByLastName(String name);

	List<Person> findByLastNameContaining(String pattern);

	List<Person> findByLastNameIgnoreCaseContaining(String pattern);
}
