package ch.frankel.blog.rx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import rx.Observable;

public abstract class AbstractTest {

    private Process process;
    protected Observable<String> observable;


    @BeforeMethod
    protected void setUp() throws IOException {
        String script = getClass().getClassLoader().getResource(getScriptName()).getFile();
        ProcessBuilder builder = new ProcessBuilder().command(script);
        process = builder.start();
        observable = Observable.create(subscriber -> {
            InputStream stream = process.getInputStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    subscriber.onNext(line);
                }
                subscriber.onCompleted();
            } catch (Exception e) {
                subscriber.onError(e);
            }
        });
    }

    @AfterMethod
    protected void tearDown() {
        process.destroy();
    }

    protected abstract String getScriptName();
}
