package ch.frankel.blog.rx;

import org.testng.annotations.Test;
import rx.observables.BlockingObservable;
import rx.schedulers.Schedulers;

import static org.testng.Assert.assertEquals;

public class InfiniteTest extends AbstractTest {

    @Test
    public void shouldReadDoingStuffMultipleTimes() throws InterruptedException {
        BlockingObservable<String> blocking = observable
            .subscribeOn(Schedulers.newThread())
            .take(5)
            .toBlocking();
        int size = 0;
        for (Object element : blocking.toIterable()) {
            assertEquals(element, "Doing stuff");
            size++;
        }
        assertEquals(size, 5);
    }

    @Override
    protected String getScriptName() {
        return "infinite.sh";
    }
}
