package ch.frankel.blog.rx;

import org.testng.annotations.Test;
import rx.observables.BlockingObservable;

import static org.testng.Assert.assertEquals;

public class FinishRandomTest extends AbstractTest {

    @Test
    public void shouldReadDoneOnce() throws InterruptedException {
    BlockingObservable<String> blocking = observable
        .filter("Done"::equals)
        .toBlocking();
        int size = 0;
        for (Object element : blocking.toIterable()) {
            assertEquals(element, "Done");
            size++;
        }
        assertEquals(size, 1);
    }

    @Override
    protected String getScriptName() {
        return "finishrandom.sh";
    }
}
