package ch.frankel.blog.spring.javaconfig;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import javax.swing.Icon;
import javax.swing.JButton;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

@ContextConfiguration(loader = AnnotationConfigContextLoader.class, classes = MigratedConfiguration.class)
public class MigratedConfigurationTest extends AbstractTestNGSpringContextTests {

	@Test
	public void buttonShouldBeLabeledHelloWorld() {
		
		Object object = applicationContext.getBean("button");
		
		assertNotNull(object);
		
		JButton button = (JButton) object;
		
		assertEquals(button.getText(), "Hello World");
	}

	@Test
	public void anotherButtonShouldHaveVaadinIcon() {
		
		Object object1 = applicationContext.getBean("anotherButton");
		Object object2 = applicationContext.getBean("icon");
		
		assertNotNull(object1);
		assertNotNull(object2);
		
		JButton button = (JButton) object1;
		Icon icon = (Icon) object2;
		
		assertEquals(icon, button.getIcon());
	}
}
