package ch.frankel.blog.spring.javaconfig;

import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MigratedConfiguration {

	@Bean
	public JButton button() {
		
		return new JButton("Hello World");
	}

	@Bean
	public JButton anotherButton(Icon icon) {
		
		return new JButton(icon);
	}
	
	@Bean
	public Icon icon() throws MalformedURLException {
		
		URL url = new URL("http://morevaadin.com/assets/images/learning_vaadin_cover.png");
		
		return new ImageIcon(url);
	}
}
