package ch.frankel.blog.spring.scope;

import static org.testng.Assert.assertNotSame;
import static org.testng.Assert.assertSame;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

@ContextConfiguration(locations = "classpath:spring-test-context.xml")
public class DefaultScopeIT extends AbstractTestNGSpringContextTests {

	@Test
	public void beanWithNoExplicitScopeShouldBeScopedPrototype() {

		Object o1 = applicationContext.getBean("beanWithNoDefaultScope");

		Object o2 = applicationContext.getBean("beanWithNoDefaultScope");

		assertNotSame(o1, o2);
	}

	@Test
	public void beanDeclaredSingletonScopedShouldBeSingleton() {

		Object o1 = applicationContext.getBean("singletonScopedBean");

		Object o2 = applicationContext.getBean("singletonScopedBean");

		assertSame(o1, o2);
	}
}
