package ch.frankel.blog.spring.viewresolver.config;

import ch.frankel.blog.spring.viewresolver.ChainableUrlBasedViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages = "ch.frankel.blog.spring.viewresolver.controller")
public class WebConfig {

    @Bean
    public ViewResolver htmlViewResolver() {

        UrlBasedViewResolver resolver = new ChainableUrlBasedViewResolver();

        resolver.setPrefix("/WEB-INF/page/");
        resolver.setSuffix(".jsp");
        resolver.setOrder(0);

        return resolver;
    }

    @Bean
    public ViewResolver jspViewResolver() {

        InternalResourceViewResolver resolver = new InternalResourceViewResolver();

        resolver.setPrefix("/WEB-INF/jsp/");
        resolver.setSuffix(".jsp");
        resolver.setOrder(1);

        return resolver;
    }
}
