package ch.frankel.blog.spring.conditional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import static ch.frankel.blog.spring.conditional.Option.EXPLICIT;
import static org.testng.Assert.assertSame;

@ContextConfiguration(classes = ConditionalConfig.class)
@ActiveProfiles("explicit")
public class ConditionalExplicitProfileTest extends AbstractTestNGSpringContextTests {

    @Autowired
    private Option option;

    @Test
    public void optionShouldBeExplicit() {
        assertSame(option, EXPLICIT);
    }
}
