package ch.frankel.blog.spring.conditional;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import static ch.frankel.blog.spring.conditional.Option.DEFAULT;
import static ch.frankel.blog.spring.conditional.Option.EXPLICIT;

@Configuration
public class ConditionalConfig {

    @Bean
    @Profile("explicit")
    public Option explicitOption() {
        return EXPLICIT;
    }

    @Bean
    @ConditionalOnMissingBean(Option.class)
    public Option defaultOption() {
        return DEFAULT;
    }
}
