package ch.frankel.blog.dozer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Date;

import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;
import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.dozer.domain.PersonTransferObject;
import ch.frankel.blog.dozer.form.PersonForm;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 11 sept. 2010
 * @version 1.0
 */
public class TypedMappingTest {

    private PersonTransferObject personTo;

    @SuppressWarnings("deprecation")
    @Before
    public void setUp() {

	personTo = new PersonTransferObject();

	personTo.setFirstName("John");
	personTo.setLastName("Doe");
	personTo.setBirthDate(new Date(0, 0, 1));
    }

    @Test
    public void testTo2VoMapping() {

	Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

	PersonForm personForm = mapper.map(personTo, PersonForm.class);

	assertNotNull(personForm);
	assertEquals("John", personForm.getFirstName());
	assertEquals("Doe", personForm.getLastName());
	assertEquals("01/01/1900", personForm.getBirthDate());
    }
}
