package ch.frankel.blog.dozer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Date;

import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;
import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.dozer.domain.PersonTransferObject;
import ch.frankel.blog.dozer.entity.PersonDataObject;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 11 sept. 2010
 * @version 1.0
 */
public class SimpleMappingTest {

    private PersonDataObject personDo;

    @SuppressWarnings("deprecation")
    @Before
    public void setUp() {

	personDo = new PersonDataObject();

	personDo.setFirstName("John");
	personDo.setLastName("Doe");
	personDo.setId(1L);
	personDo.setBirthDate(new Date(0, 0, 1));
    }

    @SuppressWarnings("deprecation")
    @Test
    public void testCreateMapping() {

	Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

	PersonTransferObject personTo = mapper.map(personDo,
		PersonTransferObject.class);

	assertNotNull(personTo);
	assertEquals("John", personTo.getFirstName());
	assertEquals("Doe", personTo.getLastName());
	assertEquals(new Date(0, 0, 1), personTo.getBirthDate());
    }

    @SuppressWarnings("deprecation")
    @Test
    public void testUseMapping() {

	PersonTransferObject personTo = new PersonTransferObject();

	Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

	mapper.map(personDo, personTo);

	assertEquals("John", personTo.getFirstName());
	assertEquals("Doe", personTo.getLastName());
	assertEquals(new Date(0, 0, 1), personTo.getBirthDate());
    }
}
