package ch.frankel.blog.dozer;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;
import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.dozer.domain.PersonTransferObject;
import ch.frankel.blog.dozer.form.PersonForm;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 11 sept. 2010
 * @version 1.0
 */
public class IdentityMappingTest {

    private PersonTransferObject personTo;

    @SuppressWarnings("deprecation")
    @Before
    public void setUp() {

	personTo = new PersonTransferObject();

	personTo.setFirstName("John");
	personTo.setLastName("Doe");
	personTo.setBirthDate(new Date(0, 0, 25));
    }

    @Test
    public void testLocaleMapping() {

	Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

	PersonForm personForm = new PersonForm();
	
	mapper.map(personTo, personForm, "en");

	assertEquals("01/25/1900", personForm.getBirthDate());
	
	mapper.map(personTo, personForm, "fr");

	assertEquals("25/01/1900", personForm.getBirthDate());
    }
}
