package ch.frankel.blog.dozer;

import static org.junit.Assert.assertEquals;

import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;
import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.dozer.domain.PersonTransferObject;
import ch.frankel.blog.dozer.entity.PersonDataObject;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 11 sept. 2010
 * @version 1.0
 */
public class CustomMappingTest {

    private PersonTransferObject personTo;

    @Before
    public void setUp() {

	personTo = new PersonTransferObject();
    }

    @Test
    public void testUseMapping() {

	PersonDataObject personDo = new PersonDataObject();

	Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

	mapper.map(personTo, personDo);

	assertEquals((Long) 25L, personDo.getId());
    }
}
