package ch.frankel.blog.jbehave.step;

import static org.junit.Assert.assertTrue;

import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;

import ch.frankel.blog.jbehave.domain.Course;
import ch.frankel.blog.jbehave.domain.Student;

public class AddCourseSteps {

	private Student student;

	private Course course;

	@Given("a student")
	public void aStudent() {

		this.student = new Student("John", "Doe");
	}

	@Given("a course")
	public void aCourse() {

		this.course = new Course("Psychology 101");
	}

	@When("the student registers in the course")
	public void heRegistersInACourse() {

		student.addCourse(course);
	}

	@Then("the course must have the student as one of its student")
	public void courseMustHaveStudent() {

		assertTrue(course.getStudents().contains(student));
	}
}
