package ch.frankel.blog.jbehave.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Teacher extends Person {

	private Set<Course> courses = new HashSet<Course>(0);

	public Teacher(String firstName, String lastName) {

		super(firstName, lastName);
	}

	public Set<Course> getCourses() {

		return Collections.unmodifiableSet(courses);
	}

	public void addCourse(Course course) {

		courses.add(course);
	}

	public void removeCourse(Course course) {

		courses.remove(course);
	}
}
