package ch.frankel.blog.jbehave.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Course {

	private Teacher teacher;

	private Set<Student> students = new HashSet<Student>(0);

	private final String label;

	public Course(String label) {

		this.label = label;
	}

	public void addStudent(Student student) {

		students.add(student);
	}

	public Set<Student> getCourses() {

		return Collections.unmodifiableSet(students);
	}

	public String getLabel() {

		return label;
	}

	public Set<Student> getStudents() {

		return students;
	}

	public Teacher getTeacher() {

		return teacher;
	}

	public void removeStudent(Student student) {

		students.remove(student);
	}

	public void setTeacher(Teacher teacher) {

		this.teacher = teacher;
	}
}
