package ch.frankel.blog.jbehave.story;

import static org.jbehave.core.reporters.StoryReporterBuilder.Format.CONSOLE;
import static org.jbehave.core.reporters.StoryReporterBuilder.Format.TXT;

import java.util.List;

import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.junit.JUnitStory;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.junit.Test;

import ch.frankel.blog.jbehave.step.AddCourseSteps;

public class StudentAddCourse extends JUnitStory {

	@Override
	public Configuration configuration() {

		return new MostUsefulConfiguration().useStoryLoader(

		new LoadFromClasspath(getClass().getClassLoader()))
				.useStoryReporterBuilder(

						new StoryReporterBuilder().withDefaultFormats()
								.withFormats(CONSOLE, TXT));
	}

	@Override
	public List<CandidateSteps> candidateSteps() {

		return new InstanceStepsFactory(configuration(), new AddCourseSteps())
				.createCandidateSteps();
	}

	@Test
	public void run() throws Throwable {

		super.run();
	}
}
