package ch.frankel.blog.jbehave.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Student extends Person {

	private Set<Course> courses = new HashSet<Course>(0);

	public Student(String firstName, String lastName) {
		
		super(firstName, lastName);
	}
	
	public void addCourse(Course course) {

		courses.add(course);

		course.addStudent(this);
	}

	public Set<Course> getCourses() {

		return Collections.unmodifiableSet(courses);
	}

	public void removeCourse(Course course) {

		courses.remove(course);
	}
}
