package ch.frankel.blog.arquillian;

import java.io.File;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

import enterprise.web_jpa_war.servlet.ListPersonServlet;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 27 mai 2012
 * @version 1.0
 */
public class WebIT extends Arquillian {

	@Test
	public void testGet() {

		// TODO Here comes the test
	}

	@Deployment
	public static WebArchive createDeployment() {

		WebArchive archive = ShrinkWrap
				.create(WebArchive.class, "web-test.war")
				.addClass(ListPersonServlet.class)
				.addAsResource(new File("src/main/resources/META-INF/persistence.xml"), "META-INF/persistence.xml")
				.setWebXML(new File("src/main/webapp/WEB-INF/web.xml"));
		
		// System.out.println(archive.toString(Formatters.VERBOSE));
		
		return archive;
	}
}
